﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.Links;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Mappers;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class GetClinicsStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (state.AppointmentType == AppointmentType.GROUP)
                throw new Exception("Invalid Message Handler Mapping");
            if (state.AppointmentType != AppointmentType.HOME_MOBILE)
                state.PatClinic = VistaSchedulingUtilities.GetClinic(state, Side.Patient);
            if (state.AppointmentType != AppointmentType.STORE_FORWARD)
                state.ProClinic = VistaSchedulingUtilities.GetClinic(state, Side.Provider);
        }
    }
}
